unit MainUnit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  SO_unit, HW,  StdCtrls, Grids, ExtCtrls, ComCtrls, Buttons, Sobre, Kill,
  PagShow, Menus, ToolWin, ImgList,  Parametros, Editor;


type
  TFMain = class(TForm)
    OpenJob: TOpenDialog;
    ToolBar1: TToolBar;
    BAbrir: TToolButton;
    BRun: TToolButton;
    BPausa: TToolButton;
    UpDown_Delay: TUpDown;
    LB_Delay: TEdit;
    Label52: TLabel;
    ToolButton4: TToolButton;
    ToolButton5: TToolButton;
    ImageList1: TImageList;
    CheckPasso: TToolButton;
    BParameters: TToolButton;
    ToolButton2: TToolButton;
    BKill: TToolButton;
    ToolButton1: TToolButton;
    ToolButton3: TToolButton;
    GroupBox1: TGroupBox;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    Label54: TLabel;
    InterGrid: TDrawGrid;
    GroupBox3: TGroupBox;
    Label22: TLabel;
    Label23: TLabel;
    Label24: TLabel;
    Label25: TLabel;
    Label26: TLabel;
    Label27: TLabel;
    Label28: TLabel;
    Label29: TLabel;
    Label33: TLabel;
    Label34: TLabel;
    Label35: TLabel;
    Label36: TLabel;
    Label37: TLabel;
    Label38: TLabel;
    Label39: TLabel;
    Label40: TLabel;
    Label41: TLabel;
    Label42: TLabel;
    Label50: TLabel;
    Label51: TLabel;
    LB_TPEnd: TLabel;
    LB_CodEnd: TLabel;
    PagCodAtual: TStringGrid;
    TabPagGrid: TStringGrid;
    GroupBoxMem: TGroupBox;
    Label14: TLabel;
    Label15: TLabel;
    Label16: TLabel;
    Label17: TLabel;
    Label18: TLabel;
    Label19: TLabel;
    Label20: TLabel;
    Label21: TLabel;
    MemGrid: TDrawGrid;
    BMemUpDown: TButton;
    GroupBox5: TGroupBox;
    Label49: TLabel;
    FJobNumPagCod: TLabel;
    FJobNumPagDados: TLabel;
    JobId: TLabel;
    FJobTimer: TLabel;
    FJobTS: TLabel;
    JobNumPagCod: TLabel;
    JobNumPagDados: TLabel;
    JobTS: TLabel;
    JobTimer: TLabel;
    GroupBox6: TGroupBox;
    Label55: TLabel;
    Label56: TLabel;
    Label57: TLabel;
    Label58: TLabel;
    Label59: TLabel;
    Label60: TLabel;
    Label61: TLabel;
    Label62: TLabel;
    EstadoPainel: TPanel;
    M1: TMemo;
    M2: TMemo;
    M3: TMemo;
    M4: TMemo;
    M5: TMemo;
    M6: TMemo;
    M7: TMemo;
    M8: TMemo;
    RIGrid: TStringGrid;
    Label43: TLabel;
    Label30: TLabel;
    Label31: TLabel;
    Label32: TLabel;
    Label46: TLabel;
    PCGrid: TStringGrid;
    Label44: TLabel;
    Label45: TLabel;
    Label47: TLabel;
    ACCLb: TLabel;
    ClockLB: TLabel;
    Label48: TLabel;
    ToolButton6: TToolButton;
    procedure BB_AbreJobClick(Sender: TObject);
    procedure MemGridDrawCell(Sender: TObject; ACol, ARow: Integer;
      Rect: TRect; State: TGridDrawState);
    procedure InterGridDrawCell(Sender: TObject; ACol, ARow: Integer; Rect: TRect; State: TGridDrawState);
    procedure FormCreate(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure BB_IniciaClick(Sender: TObject);
    procedure BB_PausaClick(Sender: TObject);
    procedure BTerminaClick(Sender: TObject);
    procedure BSobreClick(Sender: TObject);
    procedure MemGridMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure BMemUpDownClick(Sender: TObject);
    procedure LB_DelayKeyPress(Sender: TObject; var Key: Char);
    procedure BParametersClick(Sender: TObject);
    procedure ToolButton1Click(Sender: TObject);
    procedure ToolButton6Click(Sender: TObject);
  private
    function GetBitMem(i: byte): Byte;
    procedure SetBitMem(i: byte; const Value: Byte);
    function GetVInter(i: byte): boolean;
    procedure SetVInter(i: byte; const Value: boolean);

  private
    { Private declarations }
  public

    procedure ResizeMem;
    procedure ClearGrid(Grid: TStringGrid);

    procedure ExibePagAtual(PG:byte);
    procedure ExibeTabPag(Index:byte);
    procedure ExibePC;
    procedure LimpaInfoJob;
    property BitMem[i:byte]:byte read GetBitMem write SetBitMem;
    property VInter[i:byte]:boolean read GetVInter write SetVInter;


    { Public declarations }
  end;

var
  FMain: TFMain;

implementation

{$R *.DFM}

procedure TFMain.BB_AbreJobClick(Sender: TObject);
begin
     openJob.Execute;
end;


procedure TFMain.MemGridDrawCell(Sender: TObject; ACol, ARow: Integer;
  Rect: TRect; State: TGridDrawState);
var text:string[2];
    x, y, i:byte;
begin
   i:=ARow+MemGrid.RowCount*ACol;
   text:=IntToStr(i);
   x:=ACol*(MemGrid.DefaultColWidth+1)+(MemGrid.DefaultColWidth-MemGrid.Canvas.TextWidth(text)) div 2;
   y:=ARow*(MemGrid.DefaultRowHeight+1)+(MemGrid.DefaultRowHeight-MemGrid.Canvas.TextHeight(text)) div 2;
   case Memoria.Bitmap[i] of
      0:MemGrid.Canvas.Brush.Color:=clWhite;
      1:MemGrid.Canvas.Brush.Color:=clLime;
      2:MemGrid.Canvas.Brush.Color:=clYellow;
      3:MemGrid.Canvas.Brush.Color:=clAqua;
   end;
   MemGrid.Canvas.FillRect(Rect);
   MemGrid.Canvas.TextOut(x, y, text);
end;


procedure TFMain.InterGridDrawCell(Sender: TObject; ACol, ARow: Integer;
  Rect: TRect; State: TGridDrawState);
var text:string[2];
    x, y:byte;
begin
   text:=IntToStr(ARow);
   x:=(InterGrid.DefaultColWidth-InterGrid.Canvas.TextWidth(text)) div 2;
   y:=ARow*(InterGrid.DefaultRowHeight+1)+(InterGrid.DefaultRowHeight-InterGrid.Canvas.TextHeight(text)) div 2;
   if v_inter[ARow] then
       if ARow>6 then InterGrid.Canvas.Brush.Color:=clLime
       else InterGrid.Canvas.Brush.Color:=clRed
   else InterGrid.Canvas.Brush.Color:=clWhite;
   InterGrid.Canvas.FillRect(Rect);
   InterGrid.Canvas.TextOut(x, y, text);
end;

function TFMain.GetBitMem(i: byte): Byte;
begin
    Result:=Memoria.Bitmap[i];
end;

procedure TFMain.SetBitMem(i: byte; const Value: Byte);
var RW, CL:byte;
begin
    Memoria.Bitmap[i]:=Value;
    RW:= i mod MemGrid.RowCount;
    CL:= i div MemGrid.RowCount;
    MemGridDrawCell(MemGrid, CL, RW, MemGrid.CellRect(CL, RW),[]);
end;


function TFMain.GetVInter(i: byte): boolean;
begin
      Result:=v_inter[i];
end;

procedure TFMain.SetVInter(i: byte; const Value: boolean);
begin
      v_inter[i]:=value;
      InterGridDrawCell(InterGrid, 0, i,InterGrid.CellRect(0, i), []);
end;

procedure TFMain.ExibePagAtual(PG:byte);
var i:byte;
begin
    for i:=0 to tam_pagina-1 do begin
       PagCodAtual.Rows[i].Clear;
       PagCodAtual.Rows[i].Add(Instr[Memoria.Items[PG][i].c1]);
       PagCodAtual.Rows[i].Add(IntToStr(Memoria.Items[PG][i].c2));
       PagCodAtual.Rows[i].Add(IntToStr(Memoria.Items[PG][i].c3));
    end;
end;

procedure TFMain.ExibeTabPag(Index: byte);
var i:byte;
begin
    for i:=0 to tam_pagina-1 do begin
       TabPagGrid.Rows[i].Clear;
       TabPagGrid.Rows[i].Add(IntToStr(Memoria.Items[Index][i].c1));
       TabPagGrid.Rows[i].Add(IntToStr(Memoria.Items[Index][i].c2));
    end;
end;

procedure TFMain.ExibePC;
begin
   PCGrid.Cells[0,0]:= IntTOStr(PC.Pag);
   PCGrid.Cells[1,0]:= IntTOStr(PC.Desl);
end;

procedure TFMain.ClearGrid(Grid: TStringGrid);
var i:byte;
begin
    for i:=0 to Grid.RowCount-1 do Grid.Rows[i].Clear;
end;


procedure TFMain.FormCreate(Sender: TObject);
begin
     tam_memoria := 32; // Nmero pginas da memria

     SetLength(Memoria.Bitmap, 32);
     SetLength(Memoria.Items, 32);
     SetLength(Memoria.Contador, 32);

     default_TS:= 7;  //  Define o Time Slice padro
     min_TS:= 2;

     ShowMessages:=False;
     TempoLeitura:= 6;  //  Tempo gasto para transferir uma pagina do dispositivo de entrada para o buffer
     TempoDisco:= 5;  //  Tempo gasto para efetuar um acesso ao disco
     TempoImpressora:= 7; // Tempo gasto para transferir uma pgina do buffer para o dispositivo de sada
     Executando := false;
     PagCodAtual.RowCount:=tam_pagina;
     TabPagGrid.RowCount:=tam_pagina;
     ShowKill:=False;
end;

procedure TFMain.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
     Pausa:=False;
     Executando:=False;
end;

procedure TFMain.BB_IniciaClick(Sender: TObject);
begin
     Pausa:=False;

     if not Executando then begin
        Executando := true;
        Pausa := False;
        BRun.ImageIndex := 20;
        BKill.Enabled:=True;
        Principal;
     end
     else begin
         Executando:= MessageDlg('Todos os JOBs sero terminados.'+ #10+ 'Continuar?',
             mtConfirmation, [mbCancel, mbOK], 0)=mrCancel;
         if not Executando then begin
            BRun.ImageIndex := 2;
            BKill.Enabled:=False;
         end;
     end;
end;

procedure TFMain.BB_PausaClick(Sender: TObject);
begin
     if Executando then begin
         Pausa := not Pausa;
     end;
end;



procedure TFMain.LimpaInfoJob;
begin
     //Limpa a Grid da pgina de cdigo atual
     ClearGrid(FMain.PagCodAtual);
     //Limpa a Grid da pgina de cdigo atual
     ClearGrid(FMain.TabPagGrid);
     //Limpa indicador do RI na interface
     RIGrid.Rows[0].Clear;
     LB_TPEnd.Caption:='-';
     LB_CodEnd.Caption:='-';
     JobId.Caption:='-';
     JobTimer.Caption:='-';
     JobTS.Caption:='-';
     JobNumPagCod.Caption:='-';
     JobNumPagDados.Caption:='-';
end;


procedure TFMain.BTerminaClick(Sender: TObject);
begin
     ShowKill:=True;
end;


procedure TFMain.BSobreClick(Sender: TObject);
begin
   F_Sobre.ShowModal;
end;

procedure TFMain.MemGridMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
    X:=X div (MemGrid.DefaultColWidth+1);
    Y:=Y div (MemGrid.DefaultRowHeight+1);
    X:=X * MemGrid.RowCount + Y;
    FShowPag.Execute(X);
end;

procedure TFMain.BMemUpDownClick(Sender: TObject);
begin
     if not Executando then begin
          if tam_memoria=32 then begin
              MemGrid.DefaultColWidth:=22;
              tam_memoria:=64;
              ResizeMem;
              BMemUpDown.Caption:='Downgrade 32';
          end
          else begin
              MemGrid.DefaultColWidth:=28;
              tam_memoria:=32;
              ResizeMem;
              BMemUpDown.Caption:='Upgrade 64';
          end;
     end
     else MessageDlg('Upgrade ou Downgrade da memria s  possvel antes de iniciar o S.O.',
                     mtInformation, [mbOk], 0);
end;

procedure TFMain.ResizeMem;
begin
     MemGrid.ColCount:=tam_memoria div 8;
     MemGrid.Width:=MemGrid.ColCount * (MemGrid.DefaultColWidth +1) +1;
     MemGrid.Left:= (GroupBoxMem.Width-MemGrid.Width) div 2;
     SetLength(Memoria.Bitmap, tam_memoria);
     SetLength(Memoria.Items, tam_memoria);
     SetLength(Memoria.Contador, tam_memoria);
end;

procedure TFMain.LB_DelayKeyPress(Sender: TObject; var Key: Char);
begin
   if not (Key in ['0'..'9', #8]) then Key:=#0;
end;

procedure TFMain.BParametersClick(Sender: TObject);
begin
    FParametros.ShowModal;
end;

procedure TFMain.ToolButton1Click(Sender: TObject);
begin
  F_Editor.ShowModal;
end;

procedure TFMain.ToolButton6Click(Sender: TObject);
begin
   Application.Terminate;
end;

end.
